local function interactions_for_spec(spec, part)
  local grid = {}
  for i,v in pairs(spec) do
    grid_store(grid, Vector.new(i - 1, 0), part)
    if v == 1 then
      grid_store(grid, Vector.new(i - 1, 1), part)
    end
  end
  return fully_connected_object_interactions(grid)
end
local function not_spec(spec)
  local ret = {}
  for i,v in pairs(spec) do
    ret[i] = 1 - v
  end
  return ret
end

location.std.generators[1].dynamic = function(ct)
  return interactions_for_spec(get_spec(ct), 1)
end
location.std.checkers[1].dynamic = function(ct)
  return interactions_for_spec(get_spec(ct), 1)
end
location.std.checkers[2].dynamic = function(ct)
  return interactions_for_spec(not_spec(get_spec(ct)), 2)
end

local specifications =
{{1, 0, 0, 1, 1, 0, 0, 1},
{0, 0, 1, 1, 1, 0, 0, 0},
{0, 1, 0, 1, 0, 1, 1, 1},
{0, 0, 0, 1, 0, 0, 1, 1},
{1, 0, 0, 0, 0, 1, 1, 0},
{0, 1, 1, 1, 1, 1, 0, 0},
{0, 0, 1, 0, 0, 0, 0, 1},
{1, 0, 1, 0, 0, 0, 0, 0},
{1, 0, 0, 1, 0, 0, 0, 1},
{0, 0, 1, 1, 0, 0, 1, 0},
{1, 1, 0, 1, 1, 1, 0, 1},
{1, 1, 1, 0, 0, 0, 0, 0},
{0, 0, 1, 1, 0, 0, 1, 0},
{1, 0, 1, 1, 0, 0, 1, 0},
{1, 0, 1, 1, 1, 1, 1, 1},
{1, 1, 1, 1, 1, 1, 0, 1},
{0, 0, 1, 0, 1, 0, 1, 0},
{0, 1, 0, 0, 0, 1, 0, 1},
{1, 1, 1, 1, 0, 1, 0, 1},
{1, 0, 0, 0, 0, 1, 0, 0},
{1, 1, 0, 0, 1, 0, 0, 1},
{0, 0, 1, 1, 0, 0, 0, 1},
{0, 1, 1, 1, 0, 1, 1, 1},
{0, 0, 1, 0, 1, 1, 1, 0},
{1, 1, 0, 0, 0, 0, 0, 1},
{1, 0, 1, 0, 0, 0, 0, 1},
{0, 1, 0, 1, 0, 1, 1, 1},
{1, 0, 1, 0, 0, 0, 0, 1},
{0, 0, 1, 1, 0, 0, 1, 0},
{0, 0, 0, 1, 1, 0, 1, 0},
{0, 1, 0, 1, 0, 1, 1, 0},
{0, 1, 0, 0, 0, 1, 1, 1},
{0, 1, 0, 1, 0, 0, 1, 1},
{1, 0, 1, 1, 1, 0, 0, 0},
{1, 0, 0, 1, 1, 1, 0, 1},
{1, 1, 0, 0, 1, 1, 0, 1},
{1, 1, 0, 1, 0, 0, 0, 0},
{1, 0, 1, 0, 0, 1, 1, 0},
{1, 1, 0, 1, 0, 1, 0, 0},
{1, 0, 1, 1, 1, 0, 0, 0},
{1, 0, 0, 1, 0, 0, 1, 0},
{0, 1, 1, 0, 0, 0, 0, 0},
{0, 1, 1, 0, 0, 1, 1, 1},
{0, 0, 1, 1, 0, 0, 0, 1},
{1, 1, 0, 0, 0, 1, 0, 0},
{0, 1, 0, 0, 1, 1, 0, 0},
{0, 1, 0, 0, 0, 0, 0, 1},
{0, 1, 0, 0, 0, 0, 0, 1},
{1, 0, 0, 1, 0, 0, 1, 1},
{0, 1, 0, 0, 1, 0, 0, 0},
{0, 0, 0, 1, 0, 1, 0, 1},
{1, 0, 0, 0, 1, 0, 1, 0},
{1, 0, 1, 0, 1, 1, 0, 1},
{0, 0, 0, 1, 1, 1, 0, 0},
{0, 0, 1, 1, 1, 1, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 0},
{0, 0, 1, 1, 1, 0, 0, 0},
{1, 1, 1, 1, 1, 0, 1, 0},
{0, 0, 1, 0, 1, 0, 1, 0},
{0, 0, 1, 1, 0, 1, 1, 0},
{1, 0, 1, 1, 1, 1, 1, 0},
{1, 1, 0, 1, 0, 0, 1, 0},
{1, 0, 1, 1, 1, 0, 0, 1},
{0, 1, 0, 0, 0, 1, 0, 0},
{0, 0, 0, 0, 1, 1, 0, 0},
{0, 1, 1, 0, 1, 1, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0},
{0, 1, 1, 0, 0, 0, 0, 0},
{0, 0, 1, 0, 0, 0, 0, 0},
{0, 1, 1, 1, 0, 1, 0, 1},
{0, 1, 0, 1, 1, 0, 0, 1},
{0, 1, 0, 0, 0, 1, 0, 0},
{1, 1, 0, 1, 1, 0, 1, 1},
{1, 1, 1, 1, 1, 1, 1, 1},
{0, 1, 0, 0, 0, 1, 0, 0},
{0, 0, 1, 1, 1, 1, 0, 1},
{0, 0, 1, 0, 0, 0, 0, 1},
{1, 0, 1, 1, 0, 1, 1, 0},
{0, 0, 1, 0, 1, 0, 1, 0},
{0, 0, 1, 0, 0, 0, 0, 1},
{0, 1, 0, 0, 1, 0, 1, 1},
{1, 1, 1, 1, 0, 0, 1, 1},
{0, 1, 1, 1, 1, 0, 0, 1},
{1, 0, 0, 1, 0, 0, 1, 0},
{0, 1, 1, 1, 1, 0, 1, 0},
{0, 0, 0, 1, 1, 1, 0, 1},
{0, 1, 1, 0, 0, 1, 1, 0},
{1, 1, 0, 0, 0, 0, 1, 0},
{1, 0, 1, 0, 0, 1, 1, 0},
{0, 0, 1, 1, 1, 1, 1, 0},
{1, 0, 1, 1, 1, 0, 0, 1},
{1, 1, 1, 1, 0, 1, 1, 1},
{0, 0, 0, 1, 0, 1, 0, 0},
{0, 0, 0, 1, 0, 0, 1, 0},
{1, 1, 0, 0, 1, 0, 0, 1},
{1, 1, 1, 0, 1, 0, 0, 0},
{0, 1, 0, 0, 1, 0, 0, 1},
{1, 1, 1, 0, 1, 0, 0, 1},
{1, 1, 1, 0, 1, 1, 0, 1},
{1, 1, 1, 1, 1, 1, 0, 0}}
function get_spec(n)
  return specifications[(n % #specifications) + 1]
end
